var Storage = {
	set: function(key, value) {
		if (!key || !value) {
			return;
		}

		if (typeof value === "object") {
			value = JSON.stringify(value);
		}
		localStorage.setItem(key, value);
	},
	get: function(key) {
		var value = localStorage.getItem(key);
		if (!value) {
			return null;
		}
		// 尝试解析为JSON
		try {
			value = JSON.parse(value);
		} catch (e) {
			// 不是JSON，无需处理
		}
		return value;
	},
	remove: function(key) {
		localStorage.removeItem(key);
	},
	clear: function() {
		localStorage.clear();
	}
};

function getParamsByNode(node){
    const method = node.method.length > 0 ? node.method[0].toLowerCase().trim() : 'get';
	const jsonBody = node.paramNodes && node.paramNodes.length > 0 && node.paramNodes[0].jsonBody;
	const params = getParams(node, jsonBody, method, node.paramNodes);
	return params;
}

function request(node, callback) {
    const method = node.method.length > 0 ? node.method[0].toLowerCase().trim() : 'get';
	const jsonBody = node.paramNodes && node.paramNodes.length > 0 && node.paramNodes[0].jsonBody;
    const params=getParams(node, jsonBody, method, node.paramNodes);
	Storage.set(node.url, params);
	const url = replacePath(node.url, params);
	axiosRequest(node, jsonBody, url, method, params, callback);
}

/**request with axios
 * @param {Object} node
 * @param {Object} jsonBody
 * @param {Object} url
 * @param {Object} method
 * @param {Object} params
 * @param {Object} callback
 */
function axiosRequest(node, jsonBody, url, method, params, callback) {
	node.loading = true;
	let data;
	if (method == 'get') {
		url += paramsToGet(params);
		data = "";
	} else {
		if (jsonBody) {
			data = params;
		} else {
			const up = new URLSearchParams();
			for (var k in params) {
				up.append(k, params[k]);
			}
			data = up.toString();
		}
	}
	const headers = {};
	const local = Storage.get("paramValues");
	if (local && local.length > 0) {
		for (var h of local) {
			if (h.type == "header") {
				if (h.value) {
					headers[h.name] = h.value;
				}
			}
		}
	}
	const setting = Storage.get("setting");
	if (setting && setting.baseUrl) {
		if (setting.baseUrl.enable) {
			url = setting.baseUrl.value + url;
		}
	}
	axios.request({
			url: url,
			method: method,
			headers: headers,
			data: data
		})
		.then((response) => {
			node.loading = false;
			if (response.data) {
				setLocalLogin(node, response.data, setting, local,callback);
				callback("result", response.data);
			} else {
				node.result = response;
			}

		})
		.catch((error) => {
			node.loading = false;
			node.result = error;
		});
}
/** add login info to local header setting.
 * @param {Object} node
 * @param {Object} data
 * @param {Object} setting
 * @param {Object} local
 */
function setLocalLogin(node, data, setting, local,callback) {
	if (setting && setting.loginUrl &&
		setting.loginUrl.enable &&
		setting.loginUrl.value == node.url) {
		if (setting.headerKey && setting.headerKey.enable) {
			const value = setting.loginKey.value;
			let headVal = "";
			if (value && value.indexOf(".") != -1) {
				var keys = value.split(".");
				let keyData = data;
				for (var k of keys) {
					if (keyData[k] && (typeof keyData[k] === 'object')) {
						keyData = keyData[k];
					} else {
						headVal = keyData[k];
						break;
					}
				}

			}
			Storage.set("token", headVal);
			//if prefix was enabled
			if (setting.headerPrefix.enable) {
				headVal = setting.headerPrefix.value + headVal;
			}

			//find the header in local
			let isExist = false;
			if (local && local.length > 0) {
				for (var l of local) {
					if (l.name == setting.headerKey.value && l.type == "header") {
						l.value = headVal;
						isExist = true;
					}
				}
			}
			if (!isExist) {
				if (!local) {
					local = []
				}
				local.push({
					name: setting.headerKey.value,
					value: headVal,
					type: "header"
				})
			}
			Storage.set("paramValues", local);
			callback("login",local)
		}
	}

}
/**
 * when request get ,convert the param into url
 * @param {Object} param
 */
function paramsToGet(param) {
	if (!param) {
		return "";
	}
	var str = "?"
	for (var p in param) {
    	    if((!param[p]&&param[p]!=0)||param[p]=='undefined'){
    	      continue;
    	    }
    		str += p + '=' + param[p] + "&";
    }
	return str;
}
/**convert param into json;
 * @param {Object} node
 * @param {Object} jsonBody
 * @param {Object} method
 * @param {Object} params
 */
function getParams(node, jsonBody, method, params) {
	let res = {};
	if (params && params.length > 0) {
		res = {};
		if (method == 'get' || !jsonBody) {
			for (var p of params) {
				res[p.name] = p.value
			}

		} else {
			res = JSON.parse(params[0].value);
		}
	}
	//add local query.
	const local = Storage.get("paramValues");
	if (local && local.length > 0) {
		for (var q of local) {
			if (q.type == 'query') {
				res[q.name] = q.value;
			}
		}
	}
	return res;
}
/**
 * pathable 
 * @param {Object} url
 * @param {Object} params
 */
function replacePath(url, params) {
	if (!params) {
		return url;
	}
	let matches = url.match(/\{(\w+)\}/g);
	if (!matches) {
		return url;
	}
	matches.forEach((match) => {
		let prop = match.slice(1, -1);
		url = url.replace(match, params[prop]);
//		params = params.filter(function(item) {
//			return item !== prop;
//		});
	});
	return url;
}
